package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.MediaI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.core.EmailMedia;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.core.SuggestedResponses;
import com.avaya.ccs.core.WebChatMedia;

import javafx.application.Platform;
import javafx.concurrent.Task;

public class InteractionMediaEventTask extends Task<Object>{


  private final NotificationEventI<? extends MediaI> notificationEvent;
    private final InteractionDataGUI gui;
    private final SupervisorDataGUI superGui;
    private ContactType contactType;
    private static final Logger LOG = Logger.getLogger(InteractionMediaEventTask.class);
    Media interactionMedia = null;


    public InteractionMediaEventTask(NotificationEventI<? extends MediaI> nei, InteractionDataGUI interactionDataGUI,
			SupervisorDataGUI supervisorGUI, ContactType contactType	) {
    	this.notificationEvent = (NotificationEventI<? extends MediaI>) nei;
        this.gui = interactionDataGUI;
        this.superGui = supervisorGUI;
        this.contactType=contactType;
        LOG.debug("InteractionMediaEventTask constructor set contactType to" + contactType);

	}

	@Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        InteractionData data = null;
       
        NotificationType notificationType = notificationEvent.getNotificationType();
        
        LOG.debug(methodName + "Type:" + notificationType + " ID:" + notificationEvent.getNotificationObject().getId());
        
        if (contactType==ContactType.EMail)
        	interactionMedia=(EmailMedia) notificationEvent.getNotificationObject();
        else if (contactType==ContactType.Web_Communications)
        	interactionMedia=(WebChatMedia) notificationEvent.getNotificationObject();
        
     	switch (notificationType) {
	        case NEW:
	        	Platform.runLater(() -> {
	        		if (contactType==ContactType.EMail) {
			        	EmailForm thisForm=	gui.getEmailFormForContact(interactionMedia.getId());
			        	thisForm.setInteractionMedia((EmailMedia)interactionMedia); // i.e. thisInteraction.getInteractionMedia();
			        	thisForm.show();
	        		} else if (contactType==ContactType.Web_Communications) {        			
	        			String id=interactionMedia.getId();
	        			WebchatForm f = null;
	        			f=gui.getWebChatFormForContact(id);
	        			
	        			if (f==null) {
	        				LOG.info("no form found in GUI with id: "+id );
	        				f= superGui.getWebChatFormForContact(id);
	        			}
	        							
	        			try {
				        	WebChatMedia media = (WebChatMedia)interactionMedia;
				        	f.setMedia(media); 
				        	f.show();
	        			} catch (Exception e) {
	        				LOG.error("ex ", e);
	        			}

	        		}
	        	});
	        	break;
	        	
	        case OPEN:
	        	//conroy1 TODO all the info isn't present on the WebComms media object which arrives with the NEW. There's more info in the object which 
	        	//   arrives (later) with this OPEN response. So set the media object here.
	        	Platform.runLater(() -> {
	        		
	        	if (contactType==ContactType.Web_Communications) {
	        		WebchatForm f = null;
        			String id=interactionMedia.getId();
        			
        			f=gui.getWebChatFormForContact(id);
        			if (f==null)
        				f= superGui.getWebChatFormForContact(id);
        			
		        	WebChatMedia p = (WebChatMedia)interactionMedia;
		        	f.setMedia(p); 
	        		}
	        	});
	        	break;
	        	
	        case UPDATE:
	        	if (contactType==ContactType.Web_Communications) {
	        		
	        		String id = interactionMedia.getId();
	        		
	        		WebchatForm form =null;
            		
	        		form=gui.getWebChatFormForContact(id);
        			if (form==null)
        				form= superGui.getWebChatFormForContact(id);

		        	WebChatMedia media = (WebChatMedia)interactionMedia;
		        	form.updateMedia(media);
		        	if (media.getMethod().equals("customerDisconnect")) {
		        		gui.customerDisconnectedWebChat(interactionMedia.getId());
		        	}
        		} else {
        			LOG.warn(methodName, contactType + " is an unexpected contact type for Update. Not Implemented.");
        		}
	        	break;
	        case DELETE:
	        	data = new InteractionData(notificationEvent.getNotificationObject().getId(), true);
	        	if(data.getContactType()==ContactType.EMail)
	        		gui.deleteEmailFormCorContact(data.getId());
	        	else if (data.getContactType()==ContactType.Web_Communications) {
	        		gui.removeAndCloseWebChatForm(data.getId()); //conroy1 will this work OK for Supervisor (observed/barged) forms??
	        	}
	        		
	            InteractionExecutor.getTimers().stop(notificationEvent.getNotificationObject().getId());
	            break;
	        case ERROR:
	        	LOG.warn(methodName + "case Error --NOT IMPLEMENTED. interactionMedia: " +  interactionMedia);
	        	break;
	        case RESPONSE:
	            ResponseData resp = notificationEvent.getResponseData();
	            LOG.info(methodName + "case Response. ResponseData: " +  resp);
	            if (resp instanceof SuggestedResponses) {
	            	gui.getEmailFormForContact(notificationEvent.getNotificationObject().getId()).setSuggestedResponses((SuggestedResponses) resp);
	            }
	            return resp;
	        case UNKNOWN:
	        	LOG.warn(methodName + "case Unknown --NOT IMPLEMENTED. interactionMedia: " +  interactionMedia);
	        	break;
	        default:
	        	LOG.info(methodName + "case Default interactionMedia: " +  interactionMedia);
	            InteractionExecutor.getTimers().stop(notificationEvent.getNotificationObject().getId());
	            break;
	        } 

        return data;
    }

}
